/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.Rumbler;

public abstract class AbstractController
implements Controller {
    static final int EVENT_QUEUE_DEPTH = 32;
    private static final Event event = new Event();
    private final String name;
    private final Component[] components;
    private final Controller[] children;
    private final Rumbler[] rumblers;
    private final Map id_to_components = new HashMap();
    private EventQueue event_queue = new EventQueue(32);

    protected AbstractController(String name, Component[] components, Controller[] children, Rumbler[] rumblers) {
        this.name = name;
        this.components = components;
        this.children = children;
        this.rumblers = rumblers;
        for (int i2 = components.length - 1; i2 >= 0; --i2) {
            this.id_to_components.put(components[i2].getIdentifier(), components[i2]);
        }
    }

    public final Controller[] getControllers() {
        return this.children;
    }

    public final Component[] getComponents() {
        return this.components;
    }

    public final Component getComponent(Component.Identifier id2) {
        return (Component)this.id_to_components.get(id2);
    }

    public final Rumbler[] getRumblers() {
        return this.rumblers;
    }

    public Controller.PortType getPortType() {
        return Controller.PortType.UNKNOWN;
    }

    public int getPortNumber() {
        return 0;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Controller.Type getType() {
        return Controller.Type.UNKNOWN;
    }

    public final void setEventQueueSize(int size) {
        try {
            this.setDeviceEventQueueSize(size);
            this.event_queue = new EventQueue(size);
        }
        catch (IOException e) {
            ControllerEnvironment.logln("Failed to create new event queue of size " + size + ": " + e);
        }
    }

    protected void setDeviceEventQueueSize(int size) throws IOException {
    }

    public final EventQueue getEventQueue() {
        return this.event_queue;
    }

    protected abstract boolean getNextDeviceEvent(Event var1) throws IOException;

    protected void pollDevice() throws IOException {
    }

    public synchronized boolean poll() {
        Component[] components = this.getComponents();
        try {
            this.pollDevice();
            for (int i2 = 0; i2 < components.length; ++i2) {
                AbstractComponent component2 = (AbstractComponent)components[i2];
                if (component2.isRelative()) {
                    component2.setPollData(0.0f);
                    continue;
                }
                component2.resetHasPolled();
            }
            while (this.getNextDeviceEvent(event)) {
                AbstractComponent component3 = (AbstractComponent)event.getComponent();
                float value = event.getValue();
                if (component3.isRelative()) {
                    if (value == 0.0f) continue;
                    component3.setPollData(component3.getPollData() + value);
                } else {
                    if (value == component3.getEventValue()) continue;
                    component3.setEventValue(value);
                }
                if (this.event_queue.isFull()) continue;
                this.event_queue.add(event);
            }
            return true;
        }
        catch (IOException e) {
            ControllerEnvironment.logln("Failed to poll device: " + e.getMessage());
            return false;
        }
    }
}

